This example application shows how to start commissioning a Matter device when a Matter-compliant QR
code is seen in the viewfinder of the camera.

For more information, see [Intent-based Commissioning](http://fixme-intent-based-commissioning-info).

The code in this example application leverages the following Android libraries:

- [CameraX](https://developer.android.com/training/camerax)
- [Barcode Scanning](https://developers.google.com/ml-kit/vision/barcode-scanning)

The following documents are also useful to understand the code written for this example application:

- [Getting Started with CameraX](https://developer.android.com/codelabs/camerax-getting-started#0)
- [Scan Barcodes with ML Kit on Android](https://developers.google.com/ml-kit/vision/barcode-scanning/android)

### Usage

When the application starts, the camera preview is shown on the screen.
When a QR code for a Matter device is detected, a dialog is shown to confirm whether
commissioning for that Matter device should be performed.

![camera preview 1](docs/camera-preview-1.png)
![camera preview 2](docs/camera-preview-2.png){style="width:50rem; height:50rem"}

If commissioning is confirmed, then the commissioning flow supported by the Google Home Mobile SDK
is initiated.

![commissioning 1](docs/commissioning-1.png){style="width:300px; border: 1px solid black"}
![commissioning 2](docs/commissioning-2.png){style="width:300px; border: 1px solid black"}
