package com.example.matteribc

import android.content.Context
import android.os.Bundle
import androidx.appcompat.app.AlertDialog
import androidx.fragment.app.DialogFragment
import android.app.Dialog as Dialog

/**
 * The dialog used to confirm that the Matter Device should be commissioned.
 */
class ConfirmCommissioningDialogFragment: DialogFragment() {

  private val qrCode: String // QR Code captured by the camera.
    get() = requireArguments().getString(ARG_QR_CODE)!!

  // Use this instance of the interface to deliver action events
  private lateinit var listener: ConfirmCommissioningDialogListener

  /* The activity that creates an instance of this dialog fragment must
   * implement this interface in order to receive event callbacks.
   * Each method passes the DialogFragment in case the host needs to query it. */
  interface ConfirmCommissioningDialogListener {
    fun onDialogPositiveClick(dialog: DialogFragment, qrCode: String)
    fun onDialogNegativeClick(dialog: DialogFragment)
  }

  // Override the Fragment.onAttach() method to instantiate the ConfirmCommissioningDialogListener
  override fun onAttach(context: Context) {
    super.onAttach(context)
    // Verify that the host activity implements the callback interface
    check(context is ConfirmCommissioningDialogListener) {
      "${context.javaClass.name} must implement ConfirmCommissioningDialogListener"
    }
    // Instantiate the ConfirmCommissioningDialogListener so we can send events to the host
    listener = context
  }

  override fun onCreateDialog(savedInstanceState: Bundle?): Dialog =
    AlertDialog.Builder(requireContext())
      .setTitle(R.string.qr_code_detected)
      .setMessage(R.string.commission_device)
      .setPositiveButton(R.string.yes) { _, _ ->
        listener.onDialogPositiveClick(this, qrCode)
      }
      .setNegativeButton(R.string.no) { _, _ ->
        listener.onDialogNegativeClick(this)
      }
      .create()

  companion object {
    private const val ARG_QR_CODE = "qrCode"

    fun newInstance(qrCode: String): ConfirmCommissioningDialogFragment {
      return ConfirmCommissioningDialogFragment().apply {
        arguments = Bundle().apply {
          putString(ARG_QR_CODE, qrCode)
        }
      }
    }
  }
}
